/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.screen;

public class SecondOrderDynamics {
    private double xp;
    private double y;
    private double yd;
    private double k1;
    private double k2;
    private double k3;

    public SecondOrderDynamics(double f, double z, double r, double xo) {
        this.k1 = z / (Math.PI * f);
        this.k2 = 1.0 / Math.pow(Math.PI * 2 * f, 2.0);
        this.k3 = r * z / (Math.PI * 2 * f);
        this.xp = xo;
        this.y = xo;
        this.yd = 0.0;
    }

    public double update(double T, double x) {
        double xd = (x - this.xp) / T;
        this.xp = x;
        return this.update(T, x, xd);
    }

    public double update(double T, double x, double xd) {
        double k2_stable = Math.max(this.k2, Math.max(T * T / 2.0 + T * this.k1 / 2.0, T * this.k1));
        this.y += T * this.yd;
        this.yd += T * (x + this.k3 * xd - this.y - this.k1 * this.yd) / k2_stable;
        return this.y;
    }

    public double update(double f, double z, double r, double T, double x) {
        double xd = (x - this.xp) / T;
        this.xp = x;
        return this.update(f, z, r, T, x, xd);
    }

    public double update(double f, double z, double r, double T, double x, double xd) {
        double k1 = z / (Math.PI * f);
        double k2 = 1.0 / Math.pow(Math.PI * 2 * f, 2.0);
        double k3 = r * z / (Math.PI * 2 * f);
        double k2_stable = Math.max(k2, Math.max(T * T / 2.0 + T * k1 / 2.0, T * k1));
        this.y += T * this.yd;
        this.yd += T * (x + k3 * xd - this.y - k1 * this.yd) / k2_stable;
        return this.y;
    }
}

