/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.coupling.coupler;

import com.railwayteam.railways.mixin_interfaces.IHandcarTrain;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.signal.SignalPropagator;
import com.simibubi.create.content.trains.signal.SingleBlockEntityEdgePoint;
import java.util.UUID;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;

public class TrackCoupler
extends SingleBlockEntityEdgePoint {
    private int activated = 0;
    private UUID currentTrain = null;

    public void tick(TrackGraph graph, boolean preTrains) {
        super.tick(graph, preTrains);
        if (this.isActivated()) {
            --this.activated;
        }
        if (!this.isActivated()) {
            this.currentTrain = null;
        }
    }

    public UUID getCurrentTrain() {
        return this.currentTrain;
    }

    public boolean isActivated() {
        return this.activated > 0;
    }

    public void keepAlive(Train train) {
        if (((IHandcarTrain)train).railways$isHandcar()) {
            return;
        }
        this.activated = 8;
        this.currentTrain = train.id;
    }

    public void blockEntityAdded(class_2586 tile, boolean front) {
        super.blockEntityAdded(tile, front);
        this.notifyTrains(tile.method_10997());
    }

    private void notifyTrains(class_1937 level) {
        TrackGraph graph = Create.RAILWAYS.sided((class_1936)level).getGraph((class_1936)level, (TrackNodeLocation)this.edgeLocation.getFirst());
        if (graph == null) {
            return;
        }
        TrackEdge edge = graph.getConnection(this.edgeLocation.map(arg_0 -> ((TrackGraph)graph).locateNode(arg_0)));
        if (edge == null) {
            return;
        }
        SignalPropagator.notifyTrains((TrackGraph)graph, (TrackEdge[])new TrackEdge[]{edge});
    }

    public void read(class_2487 nbt, boolean migration, DimensionPalette dimensions) {
        super.read(nbt, migration, dimensions);
        this.activated = nbt.method_10550("Activated");
        if (nbt.method_10545("TrainId")) {
            this.currentTrain = nbt.method_25926("TrainId");
        }
    }

    public void read(class_2540 buffer, DimensionPalette dimensions) {
        super.read(buffer, dimensions);
        if (buffer.readBoolean()) {
            this.blockEntityPos = buffer.method_10811();
        }
    }

    public void write(class_2487 nbt, DimensionPalette dimensions) {
        super.write(nbt, dimensions);
        nbt.method_10569("Activated", this.activated);
        if (this.currentTrain != null) {
            nbt.method_25927("TrainId", this.currentTrain);
        }
    }

    public void write(class_2540 buffer, DimensionPalette dimensions) {
        super.write(buffer, dimensions);
        buffer.writeBoolean(this.blockEntityPos != null);
        if (this.blockEntityPos != null) {
            buffer.method_10807(this.blockEntityPos);
        }
    }
}

