/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.mixin_interfaces.CarriageBogeyUtils;
import com.railwayteam.railways.mixin_interfaces.ICarriageBufferDistanceTracker;
import com.railwayteam.railways.mixin_interfaces.ICarriageConductors;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.util.MixinVariables;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.foundation.utility.Couple;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Carriage.class}, remap=false)
public abstract class MixinCarriage
implements ICarriageConductors,
ICarriageBufferDistanceTracker {
    @Shadow
    public Train train;
    private final List<UUID> railways$controllingConductors = new ArrayList<UUID>();
    @Unique
    @Nullable
    private Integer railways$leadingBufferDistance = null;
    @Unique
    @Nullable
    private Integer railways$trailingBufferDistance = null;

    @Shadow
    public abstract CarriageBogey leadingBogey();

    @Shadow
    public abstract CarriageBogey trailingBogey();

    @Shadow
    public abstract TravellingPoint getLeadingPoint();

    @Shadow
    public abstract TravellingPoint getTrailingPoint();

    @Override
    public List<UUID> railways$getControllingConductors() {
        return this.railways$controllingConductors;
    }

    @Override
    @Nullable
    public Integer railways$getLeadingDistance() {
        return this.railways$leadingBufferDistance;
    }

    @Override
    @Nullable
    public Integer railways$getTrailingDistance() {
        return this.railways$trailingBufferDistance;
    }

    @Override
    public void railways$setLeadingDistance(int distance) {
        this.railways$leadingBufferDistance = distance;
    }

    @Override
    public void railways$setTrailingDistance(int distance) {
        this.railways$trailingBufferDistance = distance;
    }

    @Redirect(method={"updateConductors"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/entity/CarriageContraptionEntity;checkConductors()Lcom/simibubi/create/foundation/utility/Couple;"))
    private Couple<Boolean> addControllingConductors(CarriageContraptionEntity instance) {
        this.railways$controllingConductors.clear();
        Contraption contraption = instance.getContraption();
        if (contraption instanceof CarriageContraption) {
            CarriageContraption cc = (CarriageContraption)contraption;
            for (class_1297 passenger : instance.method_5685()) {
                Couple validSides;
                class_2338 seatOf;
                if (!(passenger instanceof ConductorEntity) || (seatOf = cc.getSeatOf(passenger.method_5667())) == null || (validSides = (Couple)cc.conductorSeats.get(seatOf)) == null || !((Boolean)validSides.getFirst()).booleanValue() && !((Boolean)validSides.getSecond()).booleanValue()) continue;
                this.railways$controllingConductors.add(passenger.method_5667());
            }
        }
        return instance.checkConductors();
    }

    @Inject(method={"write"}, at={@At(value="RETURN")})
    private void writeControllingConductors(DimensionPalette dimensions, CallbackInfoReturnable<class_2487> cir) {
        class_2487 tag = (class_2487)cir.getReturnValue();
        class_2499 listTag = new class_2499();
        for (UUID uuid : this.railways$controllingConductors) {
            class_2487 uuidTag = new class_2487();
            uuidTag.method_25927("UUID", uuid);
            listTag.add((Object)uuidTag);
        }
        tag.method_10566("ControllingConductors", (class_2520)listTag);
        if (this.railways$leadingBufferDistance != null) {
            tag.method_10569("LeadingBufferDistance", this.railways$leadingBufferDistance.intValue());
        }
        if (this.railways$trailingBufferDistance != null) {
            tag.method_10569("TrailingBufferDistance", this.railways$trailingBufferDistance.intValue());
        }
    }

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private static void readControllingConductors(class_2487 tag, TrackGraph graph, DimensionPalette dimensions, CallbackInfoReturnable<Carriage> cir) {
        Carriage carriage = (Carriage)cir.getReturnValue();
        List<UUID> controllingConductors = ((ICarriageConductors)carriage).railways$getControllingConductors();
        controllingConductors.clear();
        if (tag.method_10573("ControllingConductors", 9)) {
            class_2499 listTag = tag.method_10554("ControllingConductors", 10);
            for (class_2520 item : listTag) {
                class_2487 uuidTag;
                if (!(item instanceof class_2487) || !(uuidTag = (class_2487)item).method_25928("UUID")) continue;
                controllingConductors.add(uuidTag.method_25926("UUID"));
            }
        }
        if (tag.method_10573("LeadingBufferDistance", 3)) {
            ((ICarriageBufferDistanceTracker)carriage).railways$setLeadingDistance(tag.method_10550("LeadingBufferDistance"));
        }
        if (tag.method_10573("TrailingBufferDistance", 3)) {
            ((ICarriageBufferDistanceTracker)carriage).railways$setTrailingDistance(tag.method_10550("TrailingBufferDistance"));
        }
    }

    @Inject(method={"travel"}, at={@At(value="HEAD")})
    private void markTravelStart(class_1937 level, TrackGraph graph, double distance, TravellingPoint toFollowForward, TravellingPoint toFollowBackward, int type, CallbackInfoReturnable<Double> cir) {
        if (this.train.navigation.isActive()) {
            MixinVariables.trackEdgeCarriageTravelling = true;
        }
    }

    @Inject(method={"travel"}, at={@At(value="RETURN")})
    private void markTravelEnd(class_1937 level, TrackGraph graph, double distance, TravellingPoint toFollowForward, TravellingPoint toFollowBackward, int type, CallbackInfoReturnable<Double> cir) {
        MixinVariables.trackEdgeCarriageTravelling = false;
    }

    @ModifyExpressionValue(method={"isOnIncompatibleTrack"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/bogey/AbstractBogeyBlock;isOnIncompatibleTrack(Lcom/simibubi/create/content/trains/entity/Carriage;Z)Z", ordinal=0)})
    private boolean allowUniversalTrackLeading(boolean original) {
        return this.railways$isIncompatible(original, true);
    }

    @ModifyExpressionValue(method={"isOnIncompatibleTrack"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/bogey/AbstractBogeyBlock;isOnIncompatibleTrack(Lcom/simibubi/create/content/trains/entity/Carriage;Z)Z", ordinal=1)})
    private boolean allowUniversalTrackTrailing(boolean original) {
        return this.railways$isIncompatible(original, false);
    }

    @Unique
    private boolean railways$isIncompatible(boolean original, boolean leading) {
        TravellingPoint point;
        CarriageBogey bogey = leading ? this.leadingBogey() : this.trailingBogey();
        TravellingPoint travellingPoint = point = leading ? this.getLeadingPoint() : this.getTrailingPoint();
        if (point.edge == null) {
            return false;
        }
        if (point.edge.getTrackMaterial().trackType == CRTrackMaterials.CRTrackType.UNIVERSAL) {
            return false;
        }
        if (CarriageBogeyUtils.getType(bogey).getTrackType(bogey.getStyle()) == CRTrackMaterials.CRTrackType.UNIVERSAL) {
            return false;
        }
        return original;
    }

    @Inject(method={"manageEntities"}, at={@At(value="HEAD")}, cancellable=true)
    private void allowTravellingWithoutLevel(class_1937 level, CallbackInfo ci) {
        if (level == null) {
            ci.cancel();
        }
    }
}

