/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.mixin.AccessorCarriage;
import com.railwayteam.railways.mixin.AccessorScheduleRuntime;
import com.railwayteam.railways.mixin_interfaces.ICarriageConductors;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CREntities;
import com.simibubi.create.Create;
import com.simibubi.create.content.kinetics.deployer.DeployerFakePlayer;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.Schedule;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.condition.ScheduledDelay;
import com.simibubi.create.content.trains.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlock;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StationBlock.class}, remap=false)
public abstract class MixinStationBlock {
    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    private void autoWhistle(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_1657 pPlayer, class_1268 pHand, class_3965 pHit, CallbackInfoReturnable<class_1269> cir) {
        class_1799 itemInHand = pPlayer.method_5998(pHand);
        if (CRBlocks.CONDUCTOR_WHISTLE_FLAG.asStack().method_7909().equals(itemInHand.method_7909())) {
            class_2586 class_25862;
            if (!pLevel.field_9236 && pPlayer instanceof DeployerFakePlayer && (class_25862 = pLevel.method_8321(pPos)) instanceof StationBlockEntity) {
                StationBlockEntity stationBe = (StationBlockEntity)class_25862;
                cir.setReturnValue((Object)class_1269.field_21466);
                GlobalStation station = stationBe.getStation();
                if (station != null && station.getPresentTrain() == null) {
                    class_1799 scheduleStack;
                    class_2487 stackTag = itemInHand.method_7969();
                    if (stackTag == null || !stackTag.method_25928("SelectedTrain") || !stackTag.method_25928("SelectedConductor")) {
                        cir.setReturnValue((Object)class_1269.field_5814);
                        return;
                    }
                    class_2338 pos = stationBe.edgePoint.getPos();
                    class_1937 level = pPlayer.method_37908();
                    UUID trainId = stackTag.method_25926("SelectedTrain");
                    UUID conductorId = stackTag.method_25926("SelectedConductor");
                    Train train = (Train)Create.RAILWAYS.trains.get(trainId);
                    if (!Create.RAILWAYS.trains.containsKey(trainId)) {
                        return;
                    }
                    boolean foundConductor = false;
                    Carriage conductorCarriage = null;
                    if (train == null) {
                        return;
                    }
                    for (Object carriage : train.carriages) {
                        if (!((ICarriageConductors)carriage).railways$getControllingConductors().contains(conductorId)) continue;
                        foundConductor = true;
                        conductorCarriage = carriage;
                        break;
                    }
                    if (!foundConductor) {
                        return;
                    }
                    stackTag.method_10566("SelectedPos", (class_2520)class_2512.method_10692((class_2338)pos));
                    stackTag.method_10551("Bezier");
                    itemInHand.method_7980(stackTag);
                    if (((Boolean)CRConfigs.server().conductors.whistleRequiresOwning.get()).booleanValue() && train.runtime.getSchedule() != null && !train.runtime.completed && !train.runtime.isAutoSchedule && train.getOwner(level) != pPlayer) {
                        stackTag.method_10551("SelectedPos");
                        itemInHand.method_7980(stackTag);
                        return;
                    }
                    if (train.runtime.getSchedule() != null && !train.runtime.isAutoSchedule && !(scheduleStack = train.runtime.returnSchedule()).method_7960()) {
                        for (class_2487 passengerTag : ((AccessorCarriage)conductorCarriage).getSerialisedPassengers().values()) {
                            class_2499 schedulesList;
                            if (passengerTag.method_10545("PlayerPassenger") || !passengerTag.method_10545("id") || !CREntities.CONDUCTOR.getId().equals((Object)new class_2960(passengerTag.method_10558("id"))) || !passengerTag.method_25928("UUID") || !passengerTag.method_25926("UUID").equals(conductorId)) continue;
                            if (!passengerTag.method_10545("heldSchedules")) {
                                schedulesList = new class_2499();
                                passengerTag.method_10566("heldSchedules", (class_2520)schedulesList);
                            } else {
                                schedulesList = passengerTag.method_10554("heldSchedules", 10);
                            }
                            schedulesList.add((Object)scheduleStack.method_7953(new class_2487()));
                            scheduleStack.method_7939(0);
                            break;
                        }
                        if (!scheduleStack.method_7960()) {
                            conductorCarriage.forEachPresentEntity(cce -> {
                                if (!scheduleStack.method_7960()) {
                                    for (class_1297 passenger : cce.method_5685()) {
                                        if (!(passenger instanceof ConductorEntity)) continue;
                                        ConductorEntity conductorEntity = (ConductorEntity)passenger;
                                        if (!passenger.method_5667().equals(conductorId)) continue;
                                        conductorEntity.addSchedule(scheduleStack);
                                        scheduleStack.method_7939(0);
                                        break;
                                    }
                                }
                            });
                        }
                        if (!scheduleStack.method_7960() && !pPlayer.method_7270(scheduleStack)) {
                            pPlayer.method_7328(scheduleStack, false);
                        }
                    }
                    Schedule schedule = new Schedule();
                    ScheduleEntry entry = new ScheduleEntry();
                    DestinationInstruction instruction = new DestinationInstruction();
                    ScheduledDelay condition = new ScheduledDelay();
                    condition.getData().method_10569("Value", 0);
                    instruction.getData().method_10582("Text", station.name);
                    entry.instruction = instruction;
                    if (entry.conditions.isEmpty()) {
                        entry.conditions.add(new ArrayList());
                    }
                    ((List)entry.conditions.get(0)).add(condition);
                    schedule.entries.add(entry);
                    schedule.cyclic = false;
                    train.runtime.setSchedule(schedule, true);
                    ((AccessorScheduleRuntime)train.runtime).setCooldown(10);
                    cir.setReturnValue((Object)class_1269.field_5812);
                } else if (station != null && station.getPresentTrain() != null) {
                    UUID trainId = station.getPresentTrain().id;
                    Train train = (Train)Create.RAILWAYS.trains.get(trainId);
                    if (train == null) {
                        return;
                    }
                    AtomicBoolean found = new AtomicBoolean(false);
                    for (Carriage carriage : train.carriages) {
                        carriage.forEachPresentEntity(e -> e.method_5736().forEach(p -> {
                            if (p instanceof ConductorEntity) {
                                ConductorEntity conductor = (ConductorEntity)((Object)((Object)p));
                                if (!found.get()) {
                                    class_2487 stackTag = itemInHand.method_7948();
                                    stackTag.method_25927("SelectedTrain", train.id);
                                    stackTag.method_25927("SelectedConductor", conductor.method_5667());
                                    stackTag.method_10567("SelectedColor", ((Byte)conductor.method_5841().method_12789(ConductorEntity.COLOR)).byteValue());
                                    itemInHand.method_7980(stackTag);
                                    pPlayer.method_6122(pHand, itemInHand);
                                    cir.setReturnValue((Object)class_1269.field_5812);
                                    found.set(true);
                                }
                            }
                        }));
                    }
                }
            }
            if (CRBlocks.CONDUCTOR_WHISTLE_FLAG.isIn(itemInHand)) {
                cir.setReturnValue((Object)class_1269.field_5811);
            }
        }
    }

    @Inject(method={"use"}, at={@At(value="RETURN", ordinal=1)}, cancellable=true, remap=true)
    private void deployersAssemble(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_1657 pPlayer, class_1268 pHand, class_3965 pHit, CallbackInfoReturnable<class_1269> cir) {
        if (!pLevel.field_9236 && pPlayer instanceof DeployerFakePlayer) {
            DeployerFakePlayer deployerFakePlayer = (DeployerFakePlayer)pPlayer;
            class_2586 class_25862 = pLevel.method_8321(pPos);
            if (class_25862 instanceof StationBlockEntity) {
                StationBlockEntity stationBe = (StationBlockEntity)class_25862;
                cir.setReturnValue((Object)class_1269.field_21466);
                GlobalStation station = stationBe.getStation();
                boolean isAssemblyMode = (Boolean)pState.method_11654((class_2769)StationBlock.ASSEMBLING);
                if (station != null && station.getPresentTrain() == null) {
                    if (stationBe.isAssembling() || stationBe.tryEnterAssemblyMode()) {
                        stationBe.assemble(deployerFakePlayer.method_5667());
                        cir.setReturnValue((Object)class_1269.field_5812);
                        if (isAssemblyMode) {
                            pLevel.method_8652(pPos, (class_2680)pState.method_11657((class_2769)StationBlock.ASSEMBLING, (Comparable)Boolean.valueOf(false)), 3);
                            stationBe.refreshBlockState();
                        }
                    }
                    return;
                }
                class_2680 newState = null;
                if (!isAssemblyMode) {
                    newState = (class_2680)pState.method_11657((class_2769)StationBlock.ASSEMBLING, (Comparable)Boolean.valueOf(true));
                }
                if (this.disassembleAndEnterMode((class_3222)deployerFakePlayer, stationBe)) {
                    if (newState != null) {
                        pLevel.method_8652(pPos, newState, 3);
                        stationBe.refreshBlockState();
                        stationBe.refreshAssemblyInfo();
                    }
                    cir.setReturnValue((Object)class_1269.field_5812);
                }
            }
        }
    }

    private boolean disassembleAndEnterMode(class_3222 sender, StationBlockEntity te) {
        GlobalStation station = te.getStation();
        if (station != null) {
            class_1799 schedule;
            Train train = station.getPresentTrain();
            class_2338 trackPosition = te.edgePoint.getGlobalPosition();
            class_1799 class_17992 = schedule = train == null ? class_1799.field_8037 : train.runtime.returnSchedule();
            if (train != null && !train.disassemble(te.getAssemblyDirection(), trackPosition.method_10084())) {
                return false;
            }
            this.dropSchedule(sender, te, schedule);
        }
        return te.tryEnterAssemblyMode();
    }

    private void dropSchedule(class_3222 sender, StationBlockEntity te, class_1799 schedule) {
        if (schedule.method_7960()) {
            return;
        }
        if (sender.method_6047().method_7960()) {
            sender.method_31548().method_7398(schedule);
            return;
        }
        class_243 v = VecHelper.getCenterOf((class_2382)te.method_11016());
        class_1542 itemEntity = new class_1542(te.method_10997(), v.field_1352, v.field_1351, v.field_1350, schedule);
        itemEntity.method_18799(class_243.field_1353);
        te.method_10997().method_8649((class_1297)itemEntity);
    }
}

