/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.client;

import com.github.legoatoom.connectiblechains.ConnectibleChains;
import com.github.legoatoom.connectiblechains.client.ChainPacketHandler;
import com.github.legoatoom.connectiblechains.client.render.entity.ChainCollisionEntityRenderer;
import com.github.legoatoom.connectiblechains.client.render.entity.ChainKnotEntityRenderer;
import com.github.legoatoom.connectiblechains.client.render.entity.model.ChainKnotEntityModel;
import com.github.legoatoom.connectiblechains.config.ModConfig;
import com.github.legoatoom.connectiblechains.entity.ChainCollisionEntity;
import com.github.legoatoom.connectiblechains.entity.ChainKnotEntity;
import com.github.legoatoom.connectiblechains.entity.ModEntityTypes;
import com.github.legoatoom.connectiblechains.item.ChainItemInfo;
import com.github.legoatoom.connectiblechains.util.Helper;
import com.github.legoatoom.connectiblechains.util.NetworkingPackets;
import java.util.Optional;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.event.client.player.ClientPickBlockGatherCallback;
import net.minecraft.class_1132;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3966;
import net.minecraft.class_5601;
import net.minecraft.server.MinecraftServer;

public class ClientInitializer
implements ClientModInitializer {
    public static final class_5601 CHAIN_KNOT = new class_5601(Helper.identifier("chain_knot"), "main");
    private static ClientInitializer instance;
    private ChainKnotEntityRenderer chainKnotEntityRenderer;
    private ChainPacketHandler chainPacketHandler;

    public void onInitializeClient() {
        instance = this;
        this.initRenderers();
        this.registerNetworkEventHandlers();
        this.registerClientEventHandlers();
        ClientInitializer.registerConfigSync();
        ItemTooltipCallback.EVENT.register(ChainItemInfo::infoToolTip);
    }

    private static void registerConfigSync() {
        ConfigHolder configHolder = AutoConfig.getConfigHolder(ModConfig.class);
        configHolder.registerSaveListener((holder, modConfig) -> {
            class_1132 server;
            ClientInitializer clientInitializer = ClientInitializer.getInstance();
            if (clientInitializer != null) {
                clientInitializer.getChainKnotEntityRenderer().ifPresent(renderer -> renderer.getChainRenderer().purge());
            }
            if ((server = class_310.method_1551().method_1576()) != null) {
                ConnectibleChains.LOGGER.info("Syncing config to clients");
                ConnectibleChains.fileConfig.syncToClients((MinecraftServer)server);
                ConnectibleChains.runtimeConfig.copyFrom(ConnectibleChains.fileConfig);
            }
            return class_1269.field_5811;
        });
    }

    private void initRenderers() {
        ConnectibleChains.LOGGER.info("Initializing Renderers.");
        EntityRendererRegistry.register(ModEntityTypes.CHAIN_KNOT, ctx -> {
            this.chainKnotEntityRenderer = new ChainKnotEntityRenderer(ctx);
            return this.chainKnotEntityRenderer;
        });
        EntityRendererRegistry.register(ModEntityTypes.CHAIN_COLLISION, ChainCollisionEntityRenderer::new);
        EntityModelLayerRegistry.registerModelLayer((class_5601)CHAIN_KNOT, ChainKnotEntityModel::getTexturedModelData);
    }

    private void registerNetworkEventHandlers() {
        this.chainPacketHandler = new ChainPacketHandler();
        ClientPlayConnectionEvents.INIT.register((handler, client) -> {
            ConnectibleChains.runtimeConfig.copyFrom(ConnectibleChains.fileConfig);
            this.getChainKnotEntityRenderer().ifPresent(r -> r.getChainRenderer().purge());
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkingPackets.S2C_CONFIG_SYNC_PACKET, (client, handler, packetByteBuf, responseSender) -> {
            if (client.method_1542()) {
                return;
            }
            try {
                ConnectibleChains.LOGGER.info("Received {} config from server", (Object)"connectiblechains");
                ConnectibleChains.runtimeConfig.readPacket(packetByteBuf);
            }
            catch (Exception e) {
                ConnectibleChains.LOGGER.error("Could not deserialize config: ", (Throwable)e);
            }
            this.getChainKnotEntityRenderer().ifPresent(renderer -> renderer.getChainRenderer().purge());
        });
    }

    private void registerClientEventHandlers() {
        ClientPickBlockGatherCallback.EVENT.register((player, result) -> {
            if (result instanceof class_3966) {
                class_1297 entity = ((class_3966)result).method_17782();
                if (entity instanceof ChainKnotEntity) {
                    ChainKnotEntity knot = (ChainKnotEntity)entity;
                    return new class_1799((class_1935)knot.getChainItemSource());
                }
                if (entity instanceof ChainCollisionEntity) {
                    ChainCollisionEntity collision = (ChainCollisionEntity)entity;
                    return new class_1799((class_1935)collision.getSourceItem());
                }
            }
            return class_1799.field_8037;
        });
        ClientTickEvents.START_WORLD_TICK.register(world -> this.chainPacketHandler.tick());
    }

    public static ClientInitializer getInstance() {
        return instance;
    }

    private Optional<ChainKnotEntityRenderer> getChainKnotEntityRenderer() {
        return Optional.ofNullable(this.chainKnotEntityRenderer);
    }
}

