/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.entity;

import com.github.legoatoom.connectiblechains.ConnectibleChains;
import com.github.legoatoom.connectiblechains.chain.ChainLink;
import com.github.legoatoom.connectiblechains.entity.ChainLinkEntity;
import com.github.legoatoom.connectiblechains.entity.ModEntityTypes;
import com.github.legoatoom.connectiblechains.tag.CommonTags;
import com.github.legoatoom.connectiblechains.util.NetworkingPackets;
import com.github.legoatoom.connectiblechains.util.PacketCreator;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1530;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ChainKnotEntity
extends class_1530
implements ChainLinkEntity {
    public static final double VISIBLE_RANGE = 2048.0;
    private static final byte GRACE_PERIOD = 100;
    private final ObjectList<ChainLink> links = new ObjectArrayList();
    private final ObjectList<class_2520> incompleteLinks = new ObjectArrayList();
    private static final String SOURCE_ITEM_KEY = "SourceItem";
    private int obstructionCheckTimer = 0;
    private class_1792 chainItemSource = class_1802.field_23983;
    private byte graceTicks = (byte)100;
    @Environment(value=EnvType.CLIENT)
    private class_2680 attachTarget;

    public ChainKnotEntity(class_1299<? extends ChainKnotEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public ChainKnotEntity(class_1937 world, class_2338 pos, class_1792 source) {
        super(ModEntityTypes.CHAIN_KNOT, world, pos);
        this.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        this.chainItemSource = source;
    }

    public void method_5814(double x, double y, double z) {
        super.method_5814((double)class_3532.method_15357((double)x) + 0.5, (double)class_3532.method_15357((double)y) + 0.5, (double)class_3532.method_15357((double)z) + 0.5);
    }

    public class_1792 getChainItemSource() {
        return this.chainItemSource;
    }

    public void setChainItemSource(class_1792 chainItemSource) {
        this.chainItemSource = chainItemSource;
    }

    public void setGraceTicks(byte graceTicks) {
        this.graceTicks = graceTicks;
    }

    public void method_6892(class_2350 facing) {
    }

    protected void method_6895() {
        this.method_23327((double)this.field_7100.method_10263() + 0.5, (double)this.field_7100.method_10264() + 0.5, (double)this.field_7100.method_10260() + 0.5);
        double w = (double)this.method_5864().method_17685() / 2.0;
        double h = this.method_5864().method_17686();
        this.method_5857(new class_238(this.method_23317() - w, this.method_23318(), this.method_23321() - w, this.method_23317() + w, this.method_23318() + h, this.method_23321() + w));
    }

    public void method_5773() {
        if (this.method_37908().method_8608()) {
            this.links.removeIf(ChainLink::isDead);
            this.attachTarget = this.method_37908().method_8320(this.field_7100);
            return;
        }
        this.method_31473();
        boolean anyConverted = this.convertIncompleteLinks();
        this.updateLinks();
        this.removeDeadLinks();
        if (this.graceTicks < 0 || anyConverted && this.incompleteLinks.isEmpty()) {
            this.graceTicks = 0;
        } else if (this.graceTicks > 0) {
            this.graceTicks = (byte)(this.graceTicks - 1);
        }
    }

    private boolean convertIncompleteLinks() {
        if (!this.incompleteLinks.isEmpty()) {
            return this.incompleteLinks.removeIf(this::deserializeChainTag);
        }
        return false;
    }

    private void updateLinks() {
        double squaredMaxRange = ChainKnotEntity.getMaxRange() * ChainKnotEntity.getMaxRange();
        for (ChainLink link : this.links) {
            if (link.isDead()) continue;
            if (!this.method_5805()) {
                link.destroy(true);
                continue;
            }
            if (link.primary != this || !(link.getSquaredDistance() > squaredMaxRange)) continue;
            link.destroy(true);
        }
        if (this.obstructionCheckTimer++ == 100) {
            this.obstructionCheckTimer = 0;
            if (!this.method_6888()) {
                this.destroyLinks(true);
            }
        }
    }

    private void removeDeadLinks() {
        boolean playBreakSound = false;
        for (ChainLink link : this.links) {
            if (link.needsBeDestroyed()) {
                link.destroy(true);
            }
            if (!link.isDead() || link.removeSilently) continue;
            playBreakSound = true;
        }
        if (playBreakSound) {
            this.method_6889(null);
        }
        this.links.removeIf(ChainLink::isDead);
        if (this.links.isEmpty() && this.incompleteLinks.isEmpty() && this.graceTicks <= 0) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
    }

    private boolean deserializeChainTag(class_2520 element) {
        if (element == null || this.method_37908().method_8608()) {
            return true;
        }
        assert (element instanceof class_2487);
        class_2487 tag = (class_2487)element;
        class_1792 source = (class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)tag.method_10558(SOURCE_ITEM_KEY)));
        if (tag.method_10545("UUID")) {
            UUID uuid = tag.method_25926("UUID");
            class_1297 entity = ((class_3218)this.method_37908()).method_14190(uuid);
            if (entity != null) {
                ChainLink.create(this, entity, source);
                return true;
            }
        } else if (tag.method_10545("RelX") || tag.method_10545("RelY") || tag.method_10545("RelZ")) {
            class_2338 blockPos = new class_2338(tag.method_10550("RelX"), tag.method_10550("RelY"), tag.method_10550("RelZ"));
            blockPos = this.getBlockPosAsFacingRelative(blockPos, class_2350.method_10150((double)this.method_36454()));
            ChainKnotEntity entity = ChainKnotEntity.getKnotAt(this.method_37908(), blockPos.method_10081((class_2382)this.field_7100));
            if (entity != null) {
                ChainLink.create(this, (class_1297)entity, source);
                return true;
            }
        } else {
            ConnectibleChains.LOGGER.warn("Chain knot NBT is missing UUID or relative position.");
        }
        if (this.graceTicks <= 0) {
            this.method_5706((class_1935)source);
            this.method_6889(null);
            return true;
        }
        return false;
    }

    public static double getMaxRange() {
        return ConnectibleChains.runtimeConfig.getMaxChainRange();
    }

    public boolean method_6888() {
        class_2680 blockState = this.method_37908().method_8320(this.field_7100);
        return ChainKnotEntity.canAttachTo(blockState);
    }

    @Override
    public void destroyLinks(boolean mayDrop) {
        for (ChainLink link : this.links) {
            link.destroy(mayDrop);
        }
        this.graceTicks = 0;
    }

    public void method_6889(@Nullable class_1297 entity) {
        this.method_5783(class_3417.field_24065, 1.0f, 1.0f);
    }

    private class_2338 getBlockPosAsFacingRelative(class_2338 relPos, class_2350 facing) {
        class_2470 rotation = class_2470.values()[facing.method_10161()];
        return relPos.method_10070(rotation);
    }

    @Nullable
    public static ChainKnotEntity getKnotAt(class_1937 world, class_2338 pos) {
        List results = world.method_18467(ChainKnotEntity.class, class_238.method_30048((class_243)class_243.method_24954((class_2382)pos), (double)2.0, (double)2.0, (double)2.0));
        for (ChainKnotEntity current : results) {
            if (!current.method_6896().equals((Object)pos)) continue;
            return current;
        }
        return null;
    }

    public static boolean canAttachTo(class_2680 blockState) {
        return blockState != null && (blockState.method_26164(class_3481.field_15504) || blockState.method_26164(class_3481.field_16584));
    }

    public float method_5763(class_2415 mirror) {
        if (mirror != class_2415.field_11302) {
            for (class_2520 element : this.incompleteLinks) {
                class_2487 link;
                if (!(element instanceof class_2487) || !(link = (class_2487)element).method_10545("RelX")) continue;
                link.method_10569("RelX", -link.method_10550("RelX"));
            }
        }
        float yaw = class_3532.method_15393((float)this.method_36454());
        return switch (mirror) {
            case class_2415.field_11300 -> 180.0f - yaw;
            case class_2415.field_11301 -> -yaw;
            default -> yaw;
        };
    }

    public boolean method_5698(class_1297 attacker) {
        if (attacker instanceof class_1657) {
            class_1657 playerEntity = (class_1657)attacker;
            this.method_5643(this.method_48923().method_48802(playerEntity), 0.0f);
        } else {
            this.method_5783(class_3417.field_24062, 0.5f, 1.0f);
        }
        return true;
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1269 result = ChainLinkEntity.onDamageFrom((class_1297)this, source);
        if (result.method_23665()) {
            this.destroyLinks(result == class_1269.field_5812);
            return true;
        }
        return false;
    }

    public void method_5652(class_2487 root) {
        root.method_10582(SOURCE_ITEM_KEY, class_7923.field_41178.method_10221((Object)this.chainItemSource).toString());
        class_2499 linksTag = new class_2499();
        for (ChainLink link : this.links) {
            if (link.isDead() || link.primary != this) continue;
            class_1297 secondary = link.secondary;
            class_2487 compoundTag = new class_2487();
            compoundTag.method_10582(SOURCE_ITEM_KEY, class_7923.field_41178.method_10221((Object)link.sourceItem).toString());
            if (secondary instanceof class_1657) {
                UUID uuid = secondary.method_5667();
                compoundTag.method_25927("UUID", uuid);
            } else if (secondary instanceof class_1530) {
                class_2338 srcPos = this.field_7100;
                class_2338 dstPos = ((class_1530)secondary).method_6896();
                class_2338 relPos = dstPos.method_10059((class_2382)srcPos);
                class_2350 inverseFacing = class_2350.method_10150((double)(class_2350.field_11035.method_10144() - this.method_36454()));
                relPos = this.getBlockPosAsFacingRelative(relPos, inverseFacing);
                compoundTag.method_10569("RelX", relPos.method_10263());
                compoundTag.method_10569("RelY", relPos.method_10264());
                compoundTag.method_10569("RelZ", relPos.method_10260());
            }
            linksTag.add((Object)compoundTag);
        }
        linksTag.addAll(this.incompleteLinks);
        if (!linksTag.isEmpty()) {
            root.method_10566("Chains", (class_2520)linksTag);
        }
    }

    public void method_5749(class_2487 root) {
        if (root.method_10545("Chains")) {
            this.incompleteLinks.addAll((Collection)root.method_10554("Chains", 10));
        }
        this.chainItemSource = (class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)root.method_10558(SOURCE_ITEM_KEY)));
    }

    public int method_6897() {
        return 9;
    }

    public int method_6891() {
        return 9;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_5640(double distance) {
        return distance < 2048.0;
    }

    public class_243 method_29919() {
        return new class_243(0.0, 0.28125, 0.0);
    }

    @Environment(value=EnvType.CLIENT)
    public class_243 method_30951(float f) {
        return this.method_30950(f).method_1031(0.0, 0.28125, 0.0);
    }

    protected float method_18378(class_4050 pose, class_4048 dimensions) {
        return 0.28125f;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1799 handStack = player.method_5998(hand);
        if (this.method_37908().method_8608()) {
            if (handStack.method_31573(CommonTags.CHAINS)) {
                return class_1269.field_5812;
            }
            if (ChainLinkEntity.canDestroyWith(handStack)) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        boolean madeConnection = this.tryAttachHeldChains(player);
        if (madeConnection) {
            this.method_6894();
            return class_1269.field_21466;
        }
        boolean broke = false;
        for (ChainLink link : this.links) {
            if (link.secondary != player) continue;
            broke = true;
            link.destroy(true);
        }
        if (broke) {
            return class_1269.field_21466;
        }
        if (handStack.method_31573(CommonTags.CHAINS)) {
            this.method_6894();
            ChainLink.create(this, (class_1297)player, handStack.method_7909());
            this.updateChainType(handStack.method_7909());
            if (!player.method_7337()) {
                player.method_5998(hand).method_7934(1);
            }
            return class_1269.field_21466;
        }
        if (ChainLinkEntity.canDestroyWith(handStack)) {
            this.destroyLinks(!player.method_7337());
            this.graceTicks = 0;
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    public boolean tryAttachHeldChains(class_1657 player) {
        boolean hasMadeConnection = false;
        List<ChainLink> attachableLinks = ChainKnotEntity.getHeldChainsInRange(player, this.method_6896());
        for (ChainLink link : attachableLinks) {
            ChainLink newLink;
            if (link.primary == this || (newLink = ChainLink.create(link.primary, (class_1297)this, link.sourceItem)) == null) continue;
            link.destroy(false);
            link.removeSilently = true;
            hasMadeConnection = true;
        }
        return hasMadeConnection;
    }

    public void method_6894() {
        this.method_5783(class_3417.field_24063, 1.0f, 1.0f);
    }

    public void updateChainType(class_1792 sourceItem) {
        this.chainItemSource = sourceItem;
        if (!this.method_37908().method_8608()) {
            Collection trackingPlayers = PlayerLookup.around((class_3218)((class_3218)this.method_37908()), (class_2382)this.method_24515(), (double)2048.0);
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10804(this.method_5628());
            buf.method_10804(class_7923.field_41178.method_10206((Object)sourceItem));
            for (class_3222 player : trackingPlayers) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)NetworkingPackets.S2C_KNOT_CHANGE_TYPE_PACKET, (class_2540)buf);
            }
        }
    }

    public static List<ChainLink> getHeldChainsInRange(class_1657 player, class_2338 target) {
        class_238 searchBox = class_238.method_30048((class_243)class_243.method_24954((class_2382)target), (double)(ChainKnotEntity.getMaxRange() * 2.0), (double)(ChainKnotEntity.getMaxRange() * 2.0), (double)(ChainKnotEntity.getMaxRange() * 2.0));
        List otherKnots = player.method_37908().method_18467(ChainKnotEntity.class, searchBox);
        ArrayList<ChainLink> attachableLinks = new ArrayList<ChainLink>();
        for (ChainKnotEntity source : otherKnots) {
            for (ChainLink link : source.getLinks()) {
                if (link.secondary != player) continue;
                attachableLinks.add(link);
            }
        }
        return attachableLinks;
    }

    public List<ChainLink> getLinks() {
        return this.links;
    }

    public class_3419 method_5634() {
        return class_3419.field_15245;
    }

    public class_2596<class_2602> method_18002() {
        Function<class_2540, class_2540> extraData = packetByteBuf -> {
            packetByteBuf.method_10804(class_7923.field_41178.method_10206((Object)this.chainItemSource));
            return packetByteBuf;
        };
        return PacketCreator.createSpawn((class_1297)this, NetworkingPackets.S2C_SPAWN_CHAIN_KNOT_PACKET, extraData);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean shouldRenderKnot() {
        return this.attachTarget == null || !this.attachTarget.method_26164(class_3481.field_15504);
    }

    public void addLink(ChainLink link) {
        this.links.add((Object)link);
    }
}

