/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.jei.tags;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import mezz.jei.api.constants.Tags;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.library.ingredients.TypedIngredient;
import mezz.jei.library.plugins.jei.tags.ITagInfoRecipe;
import mezz.jei.library.plugins.jei.tags.TagInfoRecipe;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record TagInfoRecipeMaker<B, I>(IIngredientType<I> ingredientType, RecipeType<ITagInfoRecipe> recipeType, Function<B, I> baseToIngredient, class_5321<? extends class_2378<B>> registryKey) {
    private static final Logger LOGGER = LogManager.getLogger();

    public void addRecipes(IRecipeRegistration registration) {
        IIngredientManager ingredientManager = registration.getIngredientManager();
        List<ITagInfoRecipe> recipes = TagInfoRecipeMaker.createTagInfoRecipes(this.ingredientType, this.registryKey, this.baseToIngredient, ingredientManager);
        registration.addRecipes(this.recipeType, recipes);
    }

    private static <B, I> List<ITagInfoRecipe> createTagInfoRecipes(IIngredientType<I> ingredientType, class_5321<? extends class_2378<B>> registryKey, Function<B, I> baseToIngredient, IIngredientManager ingredientManager) {
        class_2378 registry = RegistryUtil.getRegistry(registryKey);
        return registry.method_40273().mapMulti((tagKey, acceptor) -> {
            if (tagKey.comp_327().method_12832().equals(Tags.HIDDEN_FROM_RECIPE_VIEWERS.method_12832())) {
                return;
            }
            List ingredients = TagInfoRecipeMaker.getIngredients(registry, tagKey, ingredientType, baseToIngredient, ingredientManager);
            if (!ingredients.isEmpty()) {
                acceptor.accept(new TagInfoRecipe(tagKey, ingredients));
            } else {
                IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
                class_2561 tagName = renderHelper.getName((class_6862<?>)tagKey);
                LOGGER.debug("No valid ingredients found for {} tag: {} ({})", (Object)registryKey.method_29177(), (Object)tagName.getString(), (Object)tagKey.comp_327());
            }
        }).toList();
    }

    private static <B, I> List<ITypedIngredient<I>> getIngredients(class_2378<B> registry, class_6862<B> tagKey, IIngredientType<I> ingredientType, Function<B, I> baseToIngredient, IIngredientManager ingredientManager) {
        ArrayList<ITypedIngredient<I>> ingredients = new ArrayList<ITypedIngredient<I>>();
        for (class_6880 i : registry.method_40286(tagKey)) {
            Object value = i.comp_349();
            I ingredient = baseToIngredient.apply(value);
            TypedIngredient.createAndFilterInvalid(ingredientManager, ingredientType, ingredient, false).ifPresent(ingredients::add);
        }
        return ingredients;
    }
}

