/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshaftsCommon;
import com.yungnickyoung.minecraft.bettermineshafts.module.StructurePieceTypeModule;
import com.yungnickyoung.minecraft.bettermineshafts.world.config.BetterMineshaftConfiguration;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.BetterMineshaftPiece;
import com.yungnickyoung.minecraft.yungsapi.world.util.BoundingBoxHelper;
import java.util.Arrays;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6130;
import net.minecraft.class_6625;

public class OreDeposit
extends BetterMineshaftPiece {
    private OreType oreType;
    private static final int SECONDARY_AXIS_LEN = 5;
    private static final int Y_AXIS_LEN = 5;
    private static final int MAIN_AXIS_LEN = 4;
    private static final int LOCAL_X_END = 4;
    private static final int LOCAL_Y_END = 4;
    private static final int LOCAL_Z_END = 3;

    public OreDeposit(class_2487 compoundTag) {
        super(StructurePieceTypeModule.ORE_DEPOSIT, compoundTag);
        this.oreType = OreType.valueOf(compoundTag.method_10550("OreType"));
    }

    public OreDeposit(int chunkPieceLen, class_3341 blockBox, class_2350 direction, BetterMineshaftConfiguration config) {
        super(StructurePieceTypeModule.ORE_DEPOSIT, chunkPieceLen, config, blockBox);
        this.method_14926(direction);
    }

    @Override
    protected void method_14943(class_6625 structurePieceSerializationContext, class_2487 compoundTag) {
        super.method_14943(structurePieceSerializationContext, compoundTag);
        compoundTag.method_10569("OreType", this.oreType.value);
    }

    public static class_3341 determineBoxPosition(class_6130 structurePieceAccessor, int x, int y, int z, class_2350 direction) {
        class_3341 blockBox = BoundingBoxHelper.boxFromCoordsWithRotation((int)x, (int)y, (int)z, (int)5, (int)5, (int)4, (class_2350)direction);
        class_3443 intersectingPiece = structurePieceAccessor.method_35461(blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void method_14918(class_3443 structurePiece, class_6130 structurePieceAccessor, class_5819 randomSource) {
        int r = randomSource.method_43048(100);
        for (OreType oreType : OreType.values()) {
            if (r >= oreType.threshold) continue;
            this.oreType = oreType;
            break;
        }
        if (OreType.DIAMOND.threshold != 100) {
            BetterMineshaftsCommon.LOGGER.error("Your ore spawn chances don't add up to 100! Ores won't spawn as you intend!");
        }
        if (this.oreType == null) {
            this.oreType = OreType.COBBLE;
        }
    }

    public void method_14931(class_5281 world, class_5138 structureManager, class_2794 chunkGenerator, class_5819 randomSource, class_3341 box, class_1923 chunkPos, class_2338 blockPos) {
        class_2680 COBBLE = class_2246.field_10445.method_9564();
        class_2680 ORE_BLOCK = this.oreType.getBlock();
        this.chanceReplaceSolid(world, box, randomSource, 0.9f, 0, 0, 0, 4, 4, 3, COBBLE);
        this.chanceReplaceSolid(world, box, randomSource, 0.65f, 1, 1, 1, 3, 3, 2, ORE_BLOCK);
        this.chanceReplaceSolid(world, box, randomSource, 0.15f, 0, 0, 0, 4, 4, 3, ORE_BLOCK);
    }

    public static enum OreType {
        COBBLE(0, class_2246.field_10445.method_9564(), BetterMineshaftsCommon.CONFIG.ores.cobble),
        COAL(1, class_2246.field_10418.method_9564(), BetterMineshaftsCommon.CONFIG.ores.coal + OreType.COBBLE.threshold),
        IRON(2, class_2246.field_10212.method_9564(), BetterMineshaftsCommon.CONFIG.ores.iron + OreType.COAL.threshold),
        REDSTONE(3, class_2246.field_10080.method_9564(), BetterMineshaftsCommon.CONFIG.ores.redstone + OreType.IRON.threshold),
        GOLD(4, class_2246.field_10571.method_9564(), BetterMineshaftsCommon.CONFIG.ores.gold + OreType.REDSTONE.threshold),
        LAPIS(5, class_2246.field_10090.method_9564(), BetterMineshaftsCommon.CONFIG.ores.lapis + OreType.GOLD.threshold),
        EMERALD(6, class_2246.field_10013.method_9564(), BetterMineshaftsCommon.CONFIG.ores.emerald + OreType.LAPIS.threshold),
        DIAMOND(7, class_2246.field_10442.method_9564(), BetterMineshaftsCommon.CONFIG.ores.diamond + OreType.EMERALD.threshold);

        private final int value;
        private final class_2680 block;
        private final int threshold;

        private OreType(int value, class_2680 block, int threshold) {
            this.value = value;
            this.block = block;
            this.threshold = threshold;
        }

        public static OreType valueOf(int value) {
            return Arrays.stream(OreType.values()).filter(oreType -> oreType.value == value).findFirst().get();
        }

        public class_2680 getBlock() {
            return this.block;
        }
    }
}

