/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.block_hit_effects;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6862;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.base.tag_utils.TypeAndTagDataHolder;
import rbasamoyai.createbigcannons.block_hit_effects.BlockHitEffect;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public class BlockHitEffectsHandler {
    private static final TypeAndTagDataHolder<class_2248, BlockHitEffect> BLOCKS = new TypeAndTagDataHolder(CBCRegistryUtils.getBlockRegistry());
    private static final TypeAndTagDataHolder<class_2248, BlockHitEffect> FLUIDS = new TypeAndTagDataHolder(CBCRegistryUtils.getBlockRegistry());

    public static void loadTags() {
        BLOCKS.loadTags();
        FLUIDS.loadTags();
    }

    public static void cleanUpTags() {
        BLOCKS.cleanUpTags();
        FLUIDS.cleanUpTags();
    }

    @Nullable
    public static BlockHitEffect getBlockProperties(class_2680 state) {
        return BlockHitEffectsHandler.getBlockProperties(state.method_26204());
    }

    @Nullable
    public static BlockHitEffect getBlockProperties(class_2248 block) {
        return BLOCKS.getData(block);
    }

    @Nullable
    public static BlockHitEffect getFluidProperties(class_2680 state) {
        return BlockHitEffectsHandler.getFluidProperties(state.method_26204());
    }

    @Nullable
    public static BlockHitEffect getFluidProperties(class_2248 block) {
        return FLUIDS.getData(block);
    }

    public static class ReloadListener
    extends class_4309 {
        private static final Gson GSON = new Gson();
        public static final ReloadListener BLOCKS_INSTANCE = new ReloadListener("block", BLOCKS);
        public static final ReloadListener FLUIDS_INSTANCE = new ReloadListener("fluid", FLUIDS);
        private final TypeAndTagDataHolder<class_2248, BlockHitEffect> holder;

        ReloadListener(String suffix, TypeAndTagDataHolder<class_2248, BlockHitEffect> holder) {
            super(GSON, "block_hit_effects/" + suffix);
            this.holder = holder;
        }

        protected void apply(Map<class_2960, JsonElement> map, class_3300 manager, class_3695 profiler) {
            this.holder.cleanUp();
            for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
                JsonElement el = entry.getValue();
                if (!el.isJsonObject()) continue;
                try {
                    class_2960 loc = entry.getKey();
                    if (loc.method_12832().startsWith("tags/")) {
                        class_2960 pruned = CBCUtils.location(loc.method_12836(), loc.method_12832().substring(5));
                        class_6862 tag = class_6862.method_40092(CBCRegistryUtils.getBlockRegistryKey(), (class_2960)pruned);
                        this.holder.addTagData((class_6862<class_2248>)tag, BlockHitEffect.fromJson(el.getAsJsonObject()));
                        continue;
                    }
                    class_2248 block = CBCRegistryUtils.getOptionalBlock(loc).orElseThrow(() -> new JsonSyntaxException("Unknown block '" + loc + "'"));
                    this.holder.addData(block, BlockHitEffect.fromJson(el.getAsJsonObject()));
                }
                catch (Exception e) {
                    CreateBigCannons.LOGGER.warn("Exception loading block hit effects: {}", (Object)e.getMessage());
                }
            }
            BlockHitEffectsHandler.loadTags();
        }
    }
}

