/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import rbasamoyai.createbigcannons.cannons.CannonContraptionProviderBlock;

public abstract class CannonBehavior
extends BlockEntityBehaviour {
    protected final Set<class_2350> connectedTowards = EnumSet.noneOf(class_2350.class);
    protected final Set<class_2350> weldedTowards = EnumSet.noneOf(class_2350.class);
    protected class_2350 currentFacing;

    protected CannonBehavior(SmartBlockEntity te) {
        super(te);
    }

    public void tick() {
        super.tick();
        class_2680 state = this.blockEntity.method_11010();
        if (state.method_28498((class_2769)class_2741.field_12525)) {
            class_2350 previousFacing = this.currentFacing;
            this.currentFacing = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
            if (previousFacing != null && previousFacing != this.currentFacing) {
                class_2350.class_2351 rotationAxis = CannonBehavior.getRotationAxis(previousFacing, this.currentFacing);
                class_2470 rotation = CannonBehavior.getRotationBetween(previousFacing, this.currentFacing, rotationAxis);
                this.onRotate(rotationAxis, rotation);
            }
        }
    }

    protected void onRotate(class_2350.class_2351 rotationAxis, class_2470 rotation) {
        EnumSet<class_2350> copyFrom = EnumSet.noneOf(class_2350.class);
        this.connectedTowards.forEach(d -> {
            class_2350 dc = d;
            for (int i = 0; i < rotation.ordinal(); ++i) {
                dc = dc.method_35833(rotationAxis);
            }
            copyFrom.add(dc);
        });
        this.connectedTowards.clear();
        this.connectedTowards.addAll(copyFrom);
        this.blockEntity.method_5431();
    }

    public boolean isConnectedTo(class_2350 face) {
        return this.connectedTowards.contains(face);
    }

    public void setConnectedFace(class_2350 face, boolean isConnected) {
        if (isConnected) {
            if (this.connectedTowards.add(face)) {
                this.blockEntity.method_5431();
            }
        } else if (this.connectedTowards.remove(face)) {
            this.blockEntity.method_5431();
        }
    }

    protected static class_2350.class_2351 getRotationAxis(class_2350 prev, class_2350 current) {
        EnumSet<class_2350.class_2351> axes = EnumSet.allOf(class_2350.class_2351.class);
        axes.remove(prev.method_10166());
        axes.remove(current.method_10166());
        return (class_2350.class_2351)axes.stream().findFirst().orElseThrow(() -> new IllegalStateException("Failed to find the rotation axes of two different axes"));
    }

    protected static class_2470 getRotationBetween(class_2350 prev, class_2350 current, class_2350.class_2351 axis) {
        if (prev == current) {
            return class_2470.field_11467;
        }
        if (prev == current.method_10153()) {
            return class_2470.field_11464;
        }
        return prev.method_35833(axis) == current ? class_2470.field_11463 : class_2470.field_11465;
    }

    public boolean isSafeNBT() {
        return true;
    }

    public void write(class_2487 nbt, boolean spawnPacket) {
        if (this.currentFacing != null) {
            nbt.method_10582("Facing", this.currentFacing.method_15434());
        }
        class_2499 connectionTag = new class_2499();
        this.connectedTowards.stream().map(class_2350::method_15434).map(class_2519::method_23256).forEach(arg_0 -> connectionTag.add(arg_0));
        nbt.method_10566("Connections", (class_2520)connectionTag);
        class_2499 weldsTag = new class_2499();
        this.weldedTowards.stream().map(class_2350::method_15434).map(class_2519::method_23256).forEach(arg_0 -> weldsTag.add(arg_0));
        nbt.method_10566("Welds", (class_2520)weldsTag);
        super.write(nbt, spawnPacket);
    }

    public void read(class_2487 nbt, boolean clientPacket) {
        this.currentFacing = nbt.method_10545("Facing") ? class_2350.method_10168((String)nbt.method_10558("Facing")) : null;
        this.connectedTowards.clear();
        class_2499 connectionTag = nbt.method_10554("Connections", 8);
        connectionTag.stream().map(class_2520::method_10714).map(class_2350::method_10168).filter(Objects::nonNull).forEach(this.connectedTowards::add);
        this.weldedTowards.clear();
        class_2499 weldsTag = nbt.method_10554("Welds", 8);
        weldsTag.stream().map(class_2520::method_10714).map(class_2350::method_10168).filter(Objects::nonNull).forEach(this.weldedTowards::add);
        super.read(nbt, clientPacket);
    }

    public void setWelded(class_2350 face, boolean welded) {
        if (welded) {
            if (this.weldedTowards.add(face)) {
                this.blockEntity.method_5431();
            }
        } else if (this.weldedTowards.remove(face)) {
            this.blockEntity.method_5431();
        }
    }

    public boolean isWelded() {
        return !this.weldedTowards.isEmpty();
    }

    public boolean isWeldedOn(class_2350 dir) {
        return this.weldedTowards.contains(dir);
    }

    public boolean canConnectToSide(class_2350 face) {
        CannonContraptionProviderBlock cBlock;
        class_2680 state = this.blockEntity.method_11010();
        class_2248 class_22482 = state.method_26204();
        return class_22482 instanceof CannonContraptionProviderBlock && (cBlock = (CannonContraptionProviderBlock)class_22482).canConnectToSide(state, face);
    }
}

