/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting;

import com.google.gson.JsonElement;
import com.simibubi.create.foundation.utility.Components;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public abstract class BlockRecipeIngredient
implements Predicate<class_2680> {
    public static final BlockRecipeIngredient NONE = new BlockRecipeIngredient(){
        private List<class_1799> ingredient;

        @Override
        public List<class_1799> getBlockItems() {
            if (this.ingredient == null) {
                this.ingredient = new ArrayList<class_1799>(1);
                this.ingredient.add(new class_1799((class_1935)class_2246.field_10499).method_7977((class_2561)Components.literal((String)"Invalid block")));
            }
            return this.ingredient;
        }

        @Override
        public boolean test(class_2680 blockState) {
            return false;
        }

        @Override
        public String stringForSerialization() {
            return "/";
        }
    };

    public static BlockRecipeIngredient of(class_2248 block) {
        return new BlockIngredient(block);
    }

    public static BlockRecipeIngredient of(class_6862<class_2248> tag) {
        return new TagIngredient(tag);
    }

    public static BlockRecipeIngredient fromJson(JsonElement el) {
        return el.isJsonPrimitive() && el.getAsJsonPrimitive().isString() ? BlockRecipeIngredient.fromString(el.getAsJsonPrimitive().getAsString()) : NONE;
    }

    public static BlockRecipeIngredient fromNetwork(class_2540 buf) {
        return BlockRecipeIngredient.fromString(buf.method_19772());
    }

    public static BlockRecipeIngredient fromString(String s) {
        return s.charAt(0) == '/' ? NONE : (s.charAt(0) == '#' ? BlockRecipeIngredient.of((class_6862<class_2248>)class_6862.method_40092(CBCRegistryUtils.getBlockRegistryKey(), (class_2960)CBCUtils.location(s.substring(1)))) : CBCRegistryUtils.getOptionalBlock(CBCUtils.location(s)).map(BlockRecipeIngredient::of).orElse(NONE));
    }

    public abstract List<class_1799> getBlockItems();

    public void toNetwork(class_2540 buf) {
        buf.method_10814(this.stringForSerialization());
    }

    public abstract String stringForSerialization();

    public static class BlockIngredient
    extends BlockRecipeIngredient {
        private final class_2248 block;
        private final List<class_1799> blocks = new ArrayList<class_1799>(1);

        protected BlockIngredient(class_2248 block) {
            this.block = block;
            this.blocks.add(new class_1799((class_1935)this.block));
        }

        @Override
        public boolean test(class_2680 blockState) {
            return blockState.method_27852(this.block);
        }

        @Override
        public List<class_1799> getBlockItems() {
            return this.blocks;
        }

        @Override
        public String stringForSerialization() {
            return CBCRegistryUtils.getBlockLocation(this.block).toString();
        }
    }

    public static class TagIngredient
    extends BlockRecipeIngredient {
        private final class_6862<class_2248> tag;
        private List<class_1799> blocks = null;

        protected TagIngredient(class_6862<class_2248> tag) {
            this.tag = tag;
        }

        @Override
        public boolean test(class_2680 blockState) {
            return blockState.method_26164(this.tag);
        }

        @Override
        public List<class_1799> getBlockItems() {
            if (this.blocks == null) {
                this.blocks = new ArrayList<class_1799>();
                for (class_6880<class_2248> holder : CBCRegistryUtils.getBlockTagEntries(this.tag)) {
                    this.blocks.add(new class_1799((class_1935)holder.comp_349()));
                }
                if (this.blocks.isEmpty()) {
                    this.blocks.add(new class_1799((class_1935)class_2246.field_10499).method_7977((class_2561)Components.literal((String)("Empty Tag: " + this.tag.comp_327()))));
                }
            }
            return this.blocks;
        }

        @Override
        public String stringForSerialization() {
            return "#" + this.tag.comp_327();
        }
    }
}

