/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.effects.particles.explosions;

import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3998;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import rbasamoyai.createbigcannons.CBCClientCommon;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.effects.particles.explosions.CannonBlastWaveEffectParticleData;
import rbasamoyai.createbigcannons.effects.particles.explosions.ShellBlastWaveEffectParticleData;
import rbasamoyai.createbigcannons.effects.sounds.AirAbsorptionWrapper;
import rbasamoyai.ritchiesprojectilelib.effects.screen_shake.ScreenShakeEffect;

public class BlastWaveEffectParticle
extends class_3998 {
    private final double blastRadius;
    private final class_3414 soundEvent;
    private final class_3419 soundSource;
    private final float volume;
    private final float pitch;
    private final float airAbsorption;
    private final float shakePower;
    private final float shakeLimit;
    private final double functionalRadius;
    private double currentRadius;

    BlastWaveEffectParticle(class_638 level, double x, double y, double z, double blastRadius, class_3414 soundEvent, class_3419 soundSource, float volume, float pitch, float airAbsorption, float shakePower, float shakeLimit) {
        super(level, x, y, z);
        this.blastRadius = blastRadius;
        this.soundEvent = soundEvent;
        this.soundSource = soundSource;
        this.volume = volume;
        this.pitch = pitch;
        this.airAbsorption = airAbsorption;
        this.shakePower = shakePower;
        this.shakeLimit = shakeLimit;
        this.functionalRadius = Math.max(this.blastRadius, (double)(this.volume * 16.0f));
        this.field_3852 = 0.0;
        this.field_3869 = 0.0;
        this.field_3850 = 0.0;
        this.field_3844 = 0.0f;
    }

    public void method_3070() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 == null) {
            this.method_3085();
            return;
        }
        boolean instant = CBCConfigs.CLIENT.isInstantaneousBlastEffect();
        if (instant) {
            this.currentRadius = 0.0;
        }
        double speed = (double)CBCConfigs.CLIENT.blastEffectDelaySpeed.getF() * 0.05;
        double newRadius = instant ? this.functionalRadius : Math.min(this.currentRadius + speed, this.functionalRadius);
        double dist = Math.sqrt(minecraft.field_1724.method_5649(this.field_3874, this.field_3854, this.field_3871));
        if (this.currentRadius <= dist && dist <= newRadius) {
            double volumeDist;
            if (dist < this.blastRadius && this.blastRadius > 0.1) {
                float f = 1.0f - (float)(dist / this.blastRadius);
                float f2 = f * f;
                float shake = Math.min(this.shakeLimit, this.shakePower * f2);
                CBCClientCommon.shakeScreenOnClient(new ScreenShakeEffect(0, shake, shake * 0.5f, shake * 0.5f, 1.0f, 1.0f, 1.0f, this.field_3874, this.field_3854, this.field_3871));
            }
            if (dist < (volumeDist = (double)(this.volume * 16.0f))) {
                Object sound = new class_1109(this.soundEvent, this.soundSource, this.volume, this.pitch, this.field_3851.field_9229, this.field_3874, this.field_3854, this.field_3871);
                if (((Boolean)CBCConfigs.CLIENT.blastSoundAirAbsorption.get()).booleanValue()) {
                    sound = new AirAbsorptionWrapper((class_1113)sound, this.airAbsorption);
                }
                minecraft.method_1483().method_4873((class_1113)sound);
            }
            this.method_3085();
            return;
        }
        if (instant || newRadius >= this.functionalRadius) {
            this.method_3085();
        } else {
            this.currentRadius = newRadius;
            super.method_3070();
        }
    }

    public static class ShellBlastProvider
    implements class_707<ShellBlastWaveEffectParticleData> {
        public class_703 createParticle(ShellBlastWaveEffectParticleData type, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            float power = type.power() * CBCConfigs.CLIENT.shellShakePowerMultiplier.getF();
            BlastWaveEffectParticle particle = new BlastWaveEffectParticle(level, x, y, z, type.blastRadius(), (class_3414)type.soundEvent().comp_349(), type.soundSource(), type.volume(), type.pitch(), type.airAbsorption(), power, CBCConfigs.CLIENT.shellShakePowerLimit.getF());
            particle.method_3077(100);
            return particle;
        }
    }

    public static class CannonBlastProvider
    implements class_707<CannonBlastWaveEffectParticleData> {
        public class_703 createParticle(CannonBlastWaveEffectParticleData type, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            float power = type.power() * CBCConfigs.CLIENT.bigCannonShakePowerMultiplier.getF();
            BlastWaveEffectParticle particle = new BlastWaveEffectParticle(level, x, y, z, type.blastRadius(), (class_3414)type.soundEvent().comp_349(), type.soundSource(), type.volume(), type.pitch(), type.airAbsorption(), power, CBCConfigs.CLIENT.bigCannonShakePowerLimit.getF());
            particle.method_3077(100);
            return particle;
        }
    }
}

