/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_3611;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.EndFluidStack;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidBlobBurst;
import rbasamoyai.ritchiesprojectilelib.projectile_burst.ProjectileBurst;

public class FluidBlobEffectRegistry {
    private static final FluidBlobEffectTypeHandler<OnHit.Context, OnHit> ON_HIT = new FluidBlobEffectTypeHandler();
    private static final FluidBlobEffectTypeHandler<OnHitBlock.Context, OnHitBlock> ON_HIT_BLOCK = new FluidBlobEffectTypeHandler();
    private static final FluidBlobEffectTypeHandler<OnHitEntity.Context, OnHitEntity> ON_HIT_ENTITY = new FluidBlobEffectTypeHandler();
    private static final FluidBlobEffectTypeHandler<OnFluidShellExplode.Context, OnFluidShellExplode> ON_FLUID_SHELL_EXPLODE = new FluidBlobEffectTypeHandler();

    public static void registerAllHit(class_3611 fluid, OnHit handler) {
        ON_HIT.registerHandler(fluid, handler);
    }

    public static void effectOnAllHit(FluidBlobBurst burst, ProjectileBurst.SubProjectile subProjectile, class_239 result) {
        EndFluidStack fstack = burst.getFluidStack();
        ON_HIT.run(fstack.fluid(), new OnHit.Context(fstack, burst, subProjectile, burst.method_37908(), result));
    }

    public static void registerHitBlock(class_3611 fluid, OnHitBlock handler) {
        ON_HIT_BLOCK.registerHandler(fluid, handler);
    }

    public static void effectOnHitBlock(FluidBlobBurst burst, ProjectileBurst.SubProjectile subProjectile, class_3965 result) {
        EndFluidStack fstack = burst.getFluidStack();
        ON_HIT_BLOCK.run(fstack.fluid(), new OnHitBlock.Context(fstack, burst, subProjectile, burst.method_37908(), result));
    }

    public static void registerHitEntity(class_3611 fluid, OnHitEntity handler) {
        ON_HIT_ENTITY.registerHandler(fluid, handler);
    }

    public static void effectOnHitEntity(FluidBlobBurst burst, ProjectileBurst.SubProjectile subProjectile, class_3966 result) {
        EndFluidStack fstack = burst.getFluidStack();
        ON_HIT_ENTITY.run(fstack.fluid(), new OnHitEntity.Context(fstack, burst, subProjectile, burst.method_37908(), result));
    }

    public static void registerFluidShellExplosionEffect(class_3611 fluid, OnFluidShellExplode handler) {
        ON_FLUID_SHELL_EXPLODE.registerHandler(fluid, handler);
    }

    public static boolean effectOnFluidShellExplode(class_3611 fluid, class_1937 level, double x, double y, double z, float radius) {
        return ON_FLUID_SHELL_EXPLODE.run(fluid, new OnFluidShellExplode.Context(fluid, level, x, y, z, radius));
    }

    private static class FluidBlobEffectTypeHandler<CONTEXT, CONSUMER extends Consumer<CONTEXT>> {
        private final Map<class_3611, List<CONSUMER>> handlers = new Reference2ReferenceOpenHashMap();
        private final Set<class_3611> fluidsWithNoHandlers = new ReferenceOpenHashSet();

        private FluidBlobEffectTypeHandler() {
        }

        public void registerHandler(class_3611 fluid, CONSUMER handler) {
            ObjectArrayList alreadyExisting = this.getMatchingHandlerCollection(fluid);
            if (alreadyExisting == null) {
                alreadyExisting = new ObjectArrayList();
                this.handlers.put(fluid, (List<CONSUMER>)alreadyExisting);
            }
            alreadyExisting.add(handler);
            this.handlers.put(fluid, (List<CONSUMER>)alreadyExisting);
            this.fluidsWithNoHandlers.remove(fluid);
        }

        private boolean run(class_3611 fluid, CONTEXT context) {
            if (this.fluidsWithNoHandlers.contains(fluid)) {
                return false;
            }
            List<CONSUMER> alreadyExisting = this.getMatchingHandlerCollection(fluid);
            if (alreadyExisting == null) {
                this.fluidsWithNoHandlers.add(fluid);
                return false;
            }
            if (!this.handlers.containsKey(fluid)) {
                this.handlers.put(fluid, alreadyExisting);
            }
            for (Consumer handler : alreadyExisting) {
                handler.accept(context);
            }
            return true;
        }

        @Nullable
        private List<CONSUMER> getMatchingHandlerCollection(class_3611 fluid) {
            if (this.handlers.containsKey(fluid)) {
                return this.handlers.get(fluid);
            }
            for (Map.Entry<class_3611, List<CONSUMER>> entry : this.handlers.entrySet()) {
                if (!entry.getKey().method_15780(fluid)) continue;
                return entry.getValue();
            }
            return null;
        }
    }

    public static interface OnHit
    extends Consumer<Context> {

        public record Context(EndFluidStack fstack, FluidBlobBurst burst, ProjectileBurst.SubProjectile subProjectile, class_1937 level, class_239 result) {
        }
    }

    public static interface OnHitBlock
    extends Consumer<Context> {

        public record Context(EndFluidStack fstack, FluidBlobBurst burst, ProjectileBurst.SubProjectile subProjectile, class_1937 level, class_3965 result) {
        }
    }

    public static interface OnHitEntity
    extends Consumer<Context> {

        public record Context(EndFluidStack fstack, FluidBlobBurst burst, ProjectileBurst.SubProjectile subProjectile, class_1937 level, class_3966 result) {
        }
    }

    public static interface OnFluidShellExplode
    extends Consumer<Context> {

        public record Context(class_3611 fluid, class_1937 level, double x, double y, double z, float radius) {
        }
    }
}

