/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.class_1299;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import rbasamoyai.createbigcannons.munitions.big_cannon.config.BigCannonFuzePropertiesComponent;
import rbasamoyai.createbigcannons.munitions.big_cannon.config.BigCannonProjectilePropertiesComponent;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidShellProperties;
import rbasamoyai.createbigcannons.munitions.config.EntityPropertiesTypeHandler;
import rbasamoyai.createbigcannons.munitions.config.components.BallisticPropertiesComponent;
import rbasamoyai.createbigcannons.munitions.config.components.EntityDamagePropertiesComponent;
import rbasamoyai.createbigcannons.munitions.config.components.ExplosionPropertiesComponent;

public class FluidShellPropertiesHandler
extends EntityPropertiesTypeHandler<FluidShellProperties> {
    private static final FluidShellProperties DEFAULT = new FluidShellProperties(BallisticPropertiesComponent.DEFAULT, EntityDamagePropertiesComponent.DEFAULT, BigCannonProjectilePropertiesComponent.DEFAULT, BigCannonFuzePropertiesComponent.DEFAULT, ExplosionPropertiesComponent.DEFAULT, 0, 0, 0, 0.0f);

    @Override
    protected FluidShellProperties parseJson(class_2960 location, JsonObject obj) throws JsonParseException {
        String id = location.toString();
        BallisticPropertiesComponent ballistics = BallisticPropertiesComponent.fromJson(id, obj);
        EntityDamagePropertiesComponent damage = EntityDamagePropertiesComponent.fromJson(id, obj);
        BigCannonProjectilePropertiesComponent bigCannonProperties = BigCannonProjectilePropertiesComponent.fromJson(id, obj);
        BigCannonFuzePropertiesComponent fuze = BigCannonFuzePropertiesComponent.fromJson(id, obj);
        ExplosionPropertiesComponent explosion = ExplosionPropertiesComponent.fromJson(id, obj);
        int fluidShellCapacity = Math.max(1, FluidShellPropertiesHandler.getOrWarn(obj, "fluid_shell_capacity", id, 2000, JsonElement::getAsInt));
        int mBPerFluidBlob = Math.max(25, FluidShellPropertiesHandler.getOrWarn(obj, "millibuckets_per_fluid_blob", id, 250, JsonElement::getAsInt));
        int mBPerAoeRadius = Math.max(25, FluidShellPropertiesHandler.getOrWarn(obj, "millibuckets_per_area_of_effect_radius", id, 50, JsonElement::getAsInt));
        float fluidBlobSpread = Math.max(0.01f, FluidShellPropertiesHandler.getOrWarn(obj, "fluid_blob_spread", id, Float.valueOf(1.0f), JsonElement::getAsFloat).floatValue());
        return new FluidShellProperties(ballistics, damage, bigCannonProperties, fuze, explosion, fluidShellCapacity, mBPerFluidBlob, mBPerAoeRadius, fluidBlobSpread);
    }

    @Override
    protected FluidShellProperties readPropertiesFromNetwork(class_1299<?> entityType, class_2540 buf) {
        BallisticPropertiesComponent ballistics = BallisticPropertiesComponent.fromNetwork(buf);
        EntityDamagePropertiesComponent damage = EntityDamagePropertiesComponent.fromNetwork(buf);
        BigCannonProjectilePropertiesComponent bigCannonProperties = BigCannonProjectilePropertiesComponent.fromNetwork(buf);
        BigCannonFuzePropertiesComponent fuze = BigCannonFuzePropertiesComponent.fromNetwork(buf);
        ExplosionPropertiesComponent explosion = ExplosionPropertiesComponent.fromNetwork(buf);
        int fluidShellCapacity = buf.method_10816();
        int mBPerFluidBlob = buf.method_10816();
        int mBPerAoeRadius = buf.method_10816();
        float fluidBlobSpread = buf.readFloat();
        return new FluidShellProperties(ballistics, damage, bigCannonProperties, fuze, explosion, fluidShellCapacity, mBPerFluidBlob, mBPerAoeRadius, fluidBlobSpread);
    }

    @Override
    protected void writePropertiesToNetwork(FluidShellProperties properties, class_2540 buf) {
        properties.ballistics().toNetwork(buf);
        properties.damage().toNetwork(buf);
        properties.bigCannonProperties().toNetwork(buf);
        properties.fuze().toNetwork(buf);
        properties.explosion().toNetwork(buf);
        buf.method_10804(properties.fluidShellCapacity()).method_10804(properties.mBPerFluidBlob()).method_10804(properties.mBPerAoeRadius()).writeFloat(properties.fluidBlobSpread());
    }

    @Override
    protected FluidShellProperties getNoPropertiesValue() {
        return DEFAULT;
    }
}

