/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.smoke_shell;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.class_1299;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import rbasamoyai.createbigcannons.munitions.big_cannon.config.BigCannonFuzePropertiesComponent;
import rbasamoyai.createbigcannons.munitions.big_cannon.config.BigCannonProjectilePropertiesComponent;
import rbasamoyai.createbigcannons.munitions.big_cannon.smoke_shell.SmokeShellProperties;
import rbasamoyai.createbigcannons.munitions.config.EntityPropertiesTypeHandler;
import rbasamoyai.createbigcannons.munitions.config.components.BallisticPropertiesComponent;
import rbasamoyai.createbigcannons.munitions.config.components.EntityDamagePropertiesComponent;

public class SmokeShellPropertiesHandler
extends EntityPropertiesTypeHandler<SmokeShellProperties> {
    private static final SmokeShellProperties DEFAULT = new SmokeShellProperties(BallisticPropertiesComponent.DEFAULT, EntityDamagePropertiesComponent.DEFAULT, BigCannonProjectilePropertiesComponent.DEFAULT, BigCannonFuzePropertiesComponent.DEFAULT, 0.0f, 0);

    @Override
    protected SmokeShellProperties parseJson(class_2960 location, JsonObject obj) throws JsonParseException {
        String id = location.toString();
        BallisticPropertiesComponent ballistics = BallisticPropertiesComponent.fromJson(id, obj);
        EntityDamagePropertiesComponent damage = EntityDamagePropertiesComponent.fromJson(id, obj);
        BigCannonProjectilePropertiesComponent bigCannonProperties = BigCannonProjectilePropertiesComponent.fromJson(id, obj);
        BigCannonFuzePropertiesComponent fuze = BigCannonFuzePropertiesComponent.fromJson(id, obj);
        float smokeScale = class_3532.method_15363((float)SmokeShellPropertiesHandler.getOrWarn(obj, "smoke_scale", id, Float.valueOf(10.0f), JsonElement::getAsFloat).floatValue(), (float)1.0f, (float)20.0f);
        int smokeDuration = Math.max(1, SmokeShellPropertiesHandler.getOrWarn(obj, "smoke_duration", id, 300, JsonElement::getAsInt));
        return new SmokeShellProperties(ballistics, damage, bigCannonProperties, fuze, smokeScale, smokeDuration);
    }

    @Override
    protected SmokeShellProperties readPropertiesFromNetwork(class_1299<?> entityType, class_2540 buf) {
        BallisticPropertiesComponent ballistics = BallisticPropertiesComponent.fromNetwork(buf);
        EntityDamagePropertiesComponent damage = EntityDamagePropertiesComponent.fromNetwork(buf);
        BigCannonProjectilePropertiesComponent bigCannonProperties = BigCannonProjectilePropertiesComponent.fromNetwork(buf);
        BigCannonFuzePropertiesComponent fuze = BigCannonFuzePropertiesComponent.fromNetwork(buf);
        float smokeScale = buf.readFloat();
        int smokeDuration = buf.method_10816();
        return new SmokeShellProperties(ballistics, damage, bigCannonProperties, fuze, smokeScale, smokeDuration);
    }

    @Override
    protected void writePropertiesToNetwork(SmokeShellProperties properties, class_2540 buf) {
        properties.ballistics().toNetwork(buf);
        properties.damage().toNetwork(buf);
        properties.bigCannonProperties().toNetwork(buf);
        properties.fuze().toNetwork(buf);
        buf.writeFloat(properties.smokeScale());
        buf.method_10804(properties.smokeDuration());
    }

    @Override
    protected SmokeShellProperties getNoPropertiesValue() {
        return DEFAULT;
    }
}

